#n_part/10 must be divisible by 4

set gamma [lindex $::argv 0]
set dt [lindex $::argv 1]
set dx [lindex $::argv 2]
set bead_size [lindex $::argv 3]
set T [lindex $::argv 4]
set nsteps [lindex $::argv 5]
set L0 [lindex $::argv 6]
set m [lindex $::argv 7]
set Eax [lindex $::argv 8]
set Ecirc [lindex $::argv 9]
set G0 [lindex $::argv 10]
set maxKE [lindex $::argv 11]
set smax [lindex $::argv 12]
set n_part [lindex $::argv 13]
set istest [lindex $::argv 14]
set loadfile [lindex $::argv 15]

set d0 8
set R 12

set n_part0 [expr int(200 * round($L0/128.))]
set L [expr $d0 * $n_part0/10.]


#scaling G by number of particles
set d [expr $d0 * 1.0 *  $n_part0 / $n_part]
set G [expr $G0  * 1.0 * $n_part * $n_part / ($n_part0 * $n_part0)]


set fd 20

set PI 3.1415926535897931
set theta $PI/5.

#h = 2.7
#h0 = 1.6

#1.77,2.22, and 1.11, etc are empirical factors 

set k_s_ax [expr $R * $R * 3.* $Eax /(1.14 *20.*$d)] 
set k_s_circ [expr 1.11* $d * $Ecirc / 3]
set k_b_circ [expr $Ecirc *$d * $R * $R/(41. * 41. *1.77)]
set k_b_ax [expr $R * $R * $R * $R * $Eax /($d * 3800. *2.35)]
set k_x [expr 0.3 *$R * $R * $G *$d / (4. * 1.05)]

set k_s_ax0 [expr $k_s_ax/$fd] 
#set k_s_circ0 [expr $k_s_circ * $fd]
#set k_b_circ0 [expr $k_b_circ * $fd]
#set k_b_ax0 [expr $k_b_ax/$fd]
#set k_x0 [expr $k_x * $fd]


set filename ""

if {$argc == 16} { 
	append filename "part2-"
}

append filename "MT"
append filename "-gamma"
append filename $gamma "_dt"
append filename $dt "_dx"
append filename $dx "_b"
append filename $bead_size "_T"
append filename $T "_nsteps"
append filename $nsteps "_L"
append filename $L0 "_n"
append filename $n_part "_m"
append filename $m "_Eax"
append filename $Eax "_Ecirc"
append filename $Ecirc "_G"
append filename $G0 "_th"
append filename $maxKE "_R"
append filename $R "_smax"
append filename $smax

if {$argc == 16} { 
	append filename "--" [string range $loadfile 0 2] 
}

append filename ".txt"

if {$istest == "test"} { set filename "test000" }

set box_l [expr 2*$L]


set seed [pid]
for {set i 0} {$i< [setmd n_nodes]} {incr i} {
        lappend Seeds [expr $seed + $i]
}
eval t_random seed $Seeds

setmd box_l $box_l $box_l $box_l
setmd periodic 0 0 0
setmd time_step $dt
setmd skin 0.1
integrate set nvt
thermostat langevin $T $gamma

inter 0 harmonic $k_s_circ [expr 2*$R * sin($theta/2.)]
inter 1 angle_harmonic $k_b_circ [expr $PI/180. *144.]
inter 2 harmonic $k_s_ax $d
inter 3 angle_harmonic $k_b_ax
inter 4 angle_harmonic $k_x [expr $PI/2.]
inter 5 harmonic [expr 50000./($bead_size*$bead_size)] [expr $bead_size]
inter 6 angle_harmonic 50000 [expr $PI/2]

#inter 7 harmonic $k_s_circ0 [expr 2*$R * sin($theta/2.)]
#inter 8 angle_harmonic $k_b_circ0 [expr $PI/180. *144.]
inter 7 harmonic $k_s_ax0 [expr $d * $fd]
#inter 10 angle_harmonic $k_b_ax
#inter 11 angle_harmonic $k_x [expr $PI/2.]

for {set i 0} { $i < 10 } {incr i} {
part $i pos [expr $L/2.] [expr $box_l/2. - $R *cos($theta*$i)] [expr $box_l/2. + $R *sin($theta*$i)] mass $m type 0
}

for {set i 0} { $i < 9 } {incr i} {
part $i bond 0 [expr $i+1]
}
part 9 bond 0 0

for {set i 1} { $i < 9 } {incr i} {
part $i bond 1 [expr $i-1] [expr $i+1]
}
part 9 bond 1 8 0
part 0 bond 1 9 1

for {set i 1} {$i < $n_part/10 - 1} {incr i} {
copy_particles range 0 9 shift [expr $d * ($i-1) + $fd*$d] 0 0
}
copy_particles range 0 9 shift [expr $d * ($i-2) + 2*$fd*$d] 0 0

for {set i 2} {$i < $n_part/10 - 1} {incr i} {
	for {set j 0} {$j < 10} {incr j} {
		part [expr ($i-1)*10+$j] bond 2 [expr $i*10 + $j]
	}
}

part 0 bond 7 10
part 1 bond 7 11
part 2 bond 7 12
part 3 bond 7 13
part 4 bond 7 14
part 5 bond 7 15
part 6 bond 7 16
part 7 bond 7 17
part 8 bond 7 18
part 9 bond 7 19

part [expr $n_part -20] bond 7 [expr $n_part - 10]
part [expr $n_part -19] bond 7 [expr $n_part - 9]
part [expr $n_part -18] bond 7 [expr $n_part - 8]
part [expr $n_part -17] bond 7 [expr $n_part - 7]
part [expr $n_part -16] bond 7 [expr $n_part - 6]
part [expr $n_part -15] bond 7 [expr $n_part - 5]
part [expr $n_part -14] bond 7 [expr $n_part - 4]
part [expr $n_part -13] bond 7 [expr $n_part - 3]
part [expr $n_part -12] bond 7 [expr $n_part - 2]
part [expr $n_part -11] bond 7 [expr $n_part - 1]

for {set i 1} {$i < $n_part/10 - 1} {incr i} {
	for {set j 0} {$j < 10} {incr j} {
		part [expr $i*10+$j] bond 3 [expr ($i-1)*10+$j] [expr ($i+1)*10+$j]
	}
}

for {set i 1} {$i < $n_part/10} {incr i} {
	for {set j 1} {$j < 10} {incr j} {
		part [expr ($i-1)*10+$j-1] bond 4 [expr ($i-1)*10+$j] [expr $i*10+$j-1]
		part [expr ($i-1)*10+$j] bond 4 [expr ($i-1)*10+$j-1] [expr $i*10+$j]
		part [expr $i*10+$j-1] bond 4 [expr ($i-1)*10+$j-1] [expr $i*10+$j]
		part [expr $i*10+$j] bond 4 [expr ($i-1)*10+$j] [expr $i*10+$j-1]
	}
}

for {set i 1} {$i < $n_part/10} {incr i} {
	part [expr ($i-1)*10+9] bond 4 [expr ($i-1)*10] [expr $i*10+9]
	part [expr ($i-1)*10] bond 4 [expr ($i-1)*10+9] [expr $i*10]
	part [expr $i*10+9] bond 4 [expr ($i-1)*10+9] [expr $i*10]
	part [expr $i*10] bond 4 [expr ($i-1)*10] [expr $i*10+9]
}

set pos_left [lindex [part [expr int(2.0*$n_part)/20] print pos] 0]
set pos_right0 [lindex [part [expr int(18.0*$n_part)/20] print pos] 0]

part $n_part pos [lindex [part [expr int(2.0*$n_part)/20] print pos] 0] [expr $box_l/2. - $bead_size - $R] [expr $box_l/2.] mass $m type 2
part [expr $n_part+1] pos [lindex [part [expr int(18.0*$n_part)/20] print pos] 0] [expr $box_l/2. - $bead_size - $R] [expr $box_l/2.] mass $m type 2


if {$argc == 16} { 
	set fp [open $loadfile r]
	set file_data [read $fp]
	close $fp
	
	set i 0
	set data [split $file_data "\n"]
	
	foreach line $data {
		global pos_right0
		part $i pos [expr [lindex $line 0]] [expr [lindex $line 1]] [expr [lindex $line 2]] mass $m type 0
		if {$i == [expr $n_part + 1]} {
			set pos_right0 [expr [lindex $line 0]] 
			break
			}
		incr i
	}
}

part $n_part bond 5 [expr int(2.0*$n_part)/20]
part [expr $n_part+1] bond 5 [expr 18*$n_part/20]
part [expr int(2.0*$n_part)/20] bond 6 0 $n_part
part [expr 18*$n_part/20] bond 6 [expr $n_part-10] [expr $n_part+1]


for {set i 1} {$i <= $n_part/10} {incr i} {
	part [expr ($i-1)*10] fix 0 0 1
	part [expr ($i-1)*10+5] fix 0 0 1
}

part [expr int(2.0*$n_part)/20] fix 0 0 1
part [expr int(2.0*$n_part)/20 + 5] fix 0 0 1
part 0 fix 0 0 1
part [expr 18*$n_part/20] fix 0 0 1
part [expr 18*$n_part/20 + 5] fix 0 0 1
part [expr $n_part-10] fix 0 0 1

part $n_part fix 1 1 1

#prepare_vmd_connection $filename start wait 3000 localhost radius {0 4 1 50 2 80}
#imd positions

#inter 0 0 lennard-jones 0.1 [expr 2*4*0.8908987] [expr 2*4] 0 0

set i 0

set pos1_id [observable new particle_positions id [expr $n_part+1]]
set pos_mid_id [observable new particle_positions id [expr $n_part/2]]
set force1_id [observable new particle_forces id [expr $n_part+1]]
set force0_id [observable new particle_forces id [expr $n_part]]

set obs [open $filename "w"]

append filename ".vtf"
set obs_vtf [open $filename "w"]

writevsf $obs_vtf

set NumSteps [expr $smax* ($pos_right0-$pos_left)/abs($dx)]

while { $i < [expr 2*$NumSteps]} {
	part [expr $n_part+1] unfix
	part [expr $n_part+1] pos [expr $pos_right0 -$dx * ($NumSteps - abs($NumSteps-$i)) ] [expr $box_l/2. - $bead_size - $R] [expr $box_l/2.]
	part [expr $n_part+1] fix
	
	imd positions
	
	while {true} {
		integrate $nsteps
		set force1 [observable $force1_id print]
		set force0 [observable $force0_id print]
		puts "$i [analyze energy kinetic] [lindex $force1 0] [lindex $force0 0]"
	#	writevcf $obs_vtf
	#	flush $obs_vtf
		if {[analyze energy kinetic] < $maxKE} {
			break
		}
	}
	
	writevcf $obs_vtf
	flush $obs_vtf
	incr i
#	imd positions
	
	set pos1 [observable $pos1_id print]
	set pos_mid [observable $pos_mid_id print]
	set force1 [observable $force1_id print]
	set force0 [observable $force0_id print]

	puts $obs "[lindex $force1 0] [expr [lindex $pos1 0] - $pos_left] [lindex $force0 0] [expr [lindex $pos_mid 1] - ($box_l/2. - $bead_size - $R)] [analyze energy total] [analyze energy kinetic] [analyze energy bonded 0] [analyze energy bonded 1] [analyze energy bonded 2] [analyze energy bonded 3] [analyze energy bonded 4] [analyze energy bonded 5] [analyze energy bonded 6]"
    flush $obs

}

close $obs
